/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import com.mojang.datafixers.util.Either;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1074;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class MarkdownScreen
extends class_437 {
    private final class_437 parent;
    private final List<Either<String, String>> markdown;
    private MarkdownWidget widget;

    public MarkdownScreen(class_2561 title, class_437 parent, String markdown) {
        super(title);
        this.parent = parent;
        String resourceId = class_1074.method_4662((String)("charta_md:" + markdown), (Object[])new Object[0]);
        class_2960 id = class_2960.method_12829((String)resourceId);
        this.markdown = id != null ? ChartaClient.MARKDOWN.getMarkdown(id) : List.of(Either.left((Object)"p"), Either.right((Object)resourceId));
    }

    protected void method_25426() {
        this.widget = (MarkdownWidget)this.method_37063((class_364)new MarkdownWidget(this.field_22787, this.field_22789, this.field_22790 - 60, 30));
        LinkedList stack = new LinkedList();
        LinkedList countStack = new LinkedList();
        AtomicInteger space = new AtomicInteger();
        AtomicBoolean started = new AtomicBoolean(false);
        class_5250 text = class_2561.method_43473();
        for (Either<String, String> either : this.markdown) {
            either.ifLeft(t -> {
                boolean isCancel = t.startsWith("/");
                MarkdownTag tag = MarkdownTag.get(t.replace("/", ""));
                if (isCancel) {
                    if (tag == MarkdownTag.OL) {
                        countStack.removeLast();
                    }
                    if (tag.start) {
                        started.set(false);
                        this.widget.addEntry(new MarkdownLine(this.field_22793, List.copyOf(stack), (class_5348)text.method_27661(), space.get(), false));
                        text.method_10855().clear();
                    }
                    stack.removeLastOccurrence((Object)tag);
                } else {
                    if (tag == MarkdownTag.OL) {
                        countStack.add(0);
                    }
                    if (tag.start) {
                        if (started.get()) {
                            this.widget.addEntry(new MarkdownLine(this.field_22793, List.copyOf(stack), (class_5348)text.method_27661(), space.get(), false));
                            text.method_10855().clear();
                        }
                        if (!this.widget.method_25396().isEmpty() && tag.line) {
                            this.widget.addEmptyEntry(this.field_22793);
                        }
                        started.set(true);
                    }
                    stack.addLast(tag);
                }
            }).ifRight(t -> {
                boolean bold = false;
                boolean italic = false;
                if (text.getString().isEmpty()) {
                    int i;
                    int listTabs = 0;
                    int numberedTabs = 0;
                    boolean numbered = false;
                    for (MarkdownTag tag : stack) {
                        switch (tag.ordinal()) {
                            case 9: {
                                ++listTabs;
                                numbered = false;
                                break;
                            }
                            case 10: {
                                ++numberedTabs;
                                numbered = true;
                            }
                        }
                    }
                    space.set(0);
                    for (i = 0; i < listTabs; ++i) {
                        text.method_27693("  ");
                        space.addAndGet(this.field_22793.method_1727("  "));
                    }
                    for (i = 0; i < numberedTabs - 1; ++i) {
                        text.method_27693("  ");
                        space.addAndGet(this.field_22793.method_1727("  "));
                    }
                    if (numbered) {
                        countStack.addLast((Integer)countStack.removeLast() + 1);
                        text.method_27693(String.valueOf(countStack.getLast()) + ". ");
                        space.addAndGet(this.field_22793.method_1727(String.valueOf(countStack.getLast()) + ". "));
                    } else if (listTabs + numberedTabs > 0) {
                        text.method_27693(" - ");
                        space.addAndGet(this.field_22793.method_1727(" - "));
                    }
                }
                for (MarkdownTag tag : stack) {
                    switch (tag.ordinal()) {
                        case 7: {
                            bold = true;
                            break;
                        }
                        case 8: {
                            italic = true;
                        }
                    }
                }
                boolean em = italic;
                boolean strong = bold;
                text.method_10852((class_2561)class_2561.method_43470((String)t).method_27694(s -> s.method_10982(Boolean.valueOf(strong)).method_10978(Boolean.valueOf(em))));
            });
        }
        if (this.parent != null) {
            class_5250 back = class_2561.method_43470((String)"\ue5c4").method_27696(Charta.SYMBOLS);
            this.method_37063((class_364)new class_4185.class_7840((class_2561)back, b -> this.method_25419()).method_46434(5, 5, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.go_back"))).method_46431());
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public static class MarkdownWidget
    extends class_4265<MarkdownLine> {
        public MarkdownWidget(class_310 minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 10);
        }

        protected void method_44397(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
            super.method_44397(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }

        public void addEmptyEntry(class_327 font) {
            super.method_25321((class_350.class_351)new MarkdownLine(font, List.of(), (class_5348)class_2561.method_43473(), 0.0, false));
        }

        public int addEntry(@NotNull MarkdownLine entry) {
            if (!entry.text.getString().isEmpty()) {
                List lines = entry.font.method_27527().method_27495(entry.text, this.method_25322(), class_2583.field_24360);
                boolean first = true;
                for (class_5348 line : lines) {
                    if (entry.tall) {
                        super.method_25321((class_350.class_351)entry.withText(line, first));
                        this.addEmptyEntry(entry.font);
                    } else {
                        super.method_25321((class_350.class_351)entry.withText(line, first));
                    }
                    first = false;
                }
            }
            return this.method_25396().size() - 1;
        }

        public int method_25322() {
            return Math.min(600, this.field_22740.method_22683().method_4486() - 32);
        }
    }

    public static enum MarkdownTag {
        P(true, true),
        H1(true, true),
        H2(true, true),
        H3(true, true),
        H4(true, true),
        H5(true, true),
        H6(true, true),
        STRONG(false, false),
        EM(false, false),
        UL(false, false),
        OL(false, false),
        LI(true, false),
        A(false, false);

        final boolean start;
        final boolean line;

        private MarkdownTag(boolean start, boolean line) {
            this.start = start;
            this.line = line;
        }

        public static MarkdownTag get(String tag) {
            try {
                return MarkdownTag.valueOf(tag.toUpperCase());
            }
            catch (Exception e) {
                return P;
            }
        }
    }

    public static class MarkdownLine
    extends class_4265.class_4266<MarkdownLine> {
        private final class_327 font;
        private final List<MarkdownTag> tags;
        private final boolean tall;
        private final class_5348 text;
        private final double space;
        private final boolean align;

        public MarkdownLine(class_327 font, List<MarkdownTag> tags, class_5348 text, double space, boolean align) {
            this.font = font;
            this.tags = tags;
            this.tall = tags.stream().anyMatch(t -> t == MarkdownTag.H1 || t == MarkdownTag.H2 || t == MarkdownTag.H3 || t == MarkdownTag.H4);
            this.text = text;
            for (MarkdownTag tag : tags) {
                switch (tag.ordinal()) {
                    case 1: {
                        space *= 2.0;
                        break;
                    }
                    case 2: {
                        space *= 1.5;
                        break;
                    }
                    case 3: {
                        space *= 1.25;
                        break;
                    }
                    case 4: {
                        space *= 1.125;
                        break;
                    }
                    case 6: {
                        space *= 0.75;
                    }
                }
            }
            this.space = space;
            this.align = align;
        }

        public MarkdownLine withText(class_5348 text, boolean first) {
            return new MarkdownLine(this.font, this.tags, text, this.space, !first);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of();
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            class_4587 stack = guiGraphics.method_51448();
            stack.method_22903();
            stack.method_46416((float)(left - 12), (float)top, 0.0f);
            if (this.align) {
                stack.method_22904(this.space, 0.0, 0.0);
            }
            for (MarkdownTag tag : this.tags) {
                switch (tag.ordinal()) {
                    case 1: {
                        stack.method_22905(2.0f, 2.0f, 2.0f);
                        break;
                    }
                    case 2: {
                        stack.method_22905(1.5f, 1.5f, 1.5f);
                        break;
                    }
                    case 3: {
                        stack.method_22905(1.25f, 1.25f, 1.25f);
                        break;
                    }
                    case 4: {
                        stack.method_22905(1.125f, 1.125f, 1.125f);
                        break;
                    }
                    case 6: {
                        stack.method_22905(0.75f, 0.75f, 0.75f);
                    }
                }
            }
            guiGraphics.method_35720(this.font, class_2477.method_10517().method_30934(this.text), 0, 0, 0xFFFFFF);
            stack.method_22909();
        }
    }
}

